using System;
using System.Data;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;


namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgDivisionWorkloadReportCriteria
	/// </summary>
	public class DlgDivisionWorkloadReportCriteria : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.Windows.Forms.GroupBox grpReportCompilation;
		private System.Windows.Forms.RadioButton rdoScheduleJob;
		private System.Windows.Forms.RadioButton rdoCreateNow;
		private System.Windows.Forms.GroupBox grpScheduleJob;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPrinterName;
		private System.Windows.Forms.Label lblPrinterName;
		private System.Windows.Forms.Label lblPrintDate;
		private System.Windows.Forms.DateTimePicker dtpPrintDate;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picImage;
		private System.Windows.Forms.GroupBox grpDateRange;
		private System.Windows.Forms.DateTimePicker dtpEndDate;
		private System.Windows.Forms.Label lblEndDate;
		private System.Windows.Forms.Label lblStartDate;
		private System.Windows.Forms.DateTimePicker dtpStartDate;
		private System.Windows.Forms.GroupBox grpDivision;
		private System.Windows.Forms.RadioButton rdoCurrentDivision;
		private System.Windows.Forms.RadioButton rdoAllDivisions;
		private System.ComponentModel.IContainer components = null;
		private Form _mdiParent;
		private bool _singleDivision;
		private BOL.WorkloadReport workloadReport; 

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="mdiParent"></param>
		public DlgDivisionWorkloadReportCriteria(Form mdiParent)
		{
			// Added 1/6/05 RDH
			workloadReport = new BOL.WorkloadReport();

			// This call is required by the Windows Form Designer.
			InitializeComponent();
			this._mdiParent = mdiParent;
			this._singleDivision = true;
			SetComponentProperties();

			// Added 1/6/05 RDH
			this.LoadPrinters();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgDivisionWorkloadReportCriteria));
			this.grpDivision = new System.Windows.Forms.GroupBox();
			this.rdoCurrentDivision = new System.Windows.Forms.RadioButton();
			this.rdoAllDivisions = new System.Windows.Forms.RadioButton();
			this.grpReportCompilation = new System.Windows.Forms.GroupBox();
			this.rdoScheduleJob = new System.Windows.Forms.RadioButton();
			this.rdoCreateNow = new System.Windows.Forms.RadioButton();
			this.grpScheduleJob = new System.Windows.Forms.GroupBox();
			this.cmbPrinterName = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblPrinterName = new System.Windows.Forms.Label();
			this.lblPrintDate = new System.Windows.Forms.Label();
			this.dtpPrintDate = new System.Windows.Forms.DateTimePicker();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picImage = new System.Windows.Forms.PictureBox();
			this.grpDateRange = new System.Windows.Forms.GroupBox();
			this.dtpEndDate = new System.Windows.Forms.DateTimePicker();
			this.lblEndDate = new System.Windows.Forms.Label();
			this.lblStartDate = new System.Windows.Forms.Label();
			this.dtpStartDate = new System.Windows.Forms.DateTimePicker();
			this.grpDivision.SuspendLayout();
			this.grpReportCompilation.SuspendLayout();
			this.grpScheduleJob.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.grpDateRange.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(392, 30);
			this.vbecsLogo1.TabIndex = 5;
			this.vbecsLogo1.Title = "Division Workload Report";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 289);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 7;
			// 
			// grpDivision
			// 
			this.grpDivision.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDivision.Controls.Add(this.rdoCurrentDivision);
			this.grpDivision.Controls.Add(this.rdoAllDivisions);
			this.grpDivision.Location = new System.Drawing.Point(60, 84);
			this.grpDivision.Name = "grpDivision";
			this.grpDivision.Size = new System.Drawing.Size(328, 64);
			this.grpDivision.TabIndex = 1;
			this.grpDivision.TabStop = false;
			this.grpDivision.Text = "Division*";
			// 
			// rdoCurrentDivision
			// 
			this.rdoCurrentDivision.Checked = true;
			this.rdoCurrentDivision.Location = new System.Drawing.Point(8, 16);
			this.rdoCurrentDivision.Name = "rdoCurrentDivision";
			this.rdoCurrentDivision.Size = new System.Drawing.Size(112, 20);
			this.rdoCurrentDivision.TabIndex = 0;
			this.rdoCurrentDivision.TabStop = true;
			this.rdoCurrentDivision.Text = "Current &Division";
			this.rdoCurrentDivision.Click += new System.EventHandler(this.rdoCurrentDivision_Click);
			// 
			// rdoAllDivisions
			// 
			this.rdoAllDivisions.Location = new System.Drawing.Point(8, 36);
			this.rdoAllDivisions.Name = "rdoAllDivisions";
			this.rdoAllDivisions.Size = new System.Drawing.Size(156, 20);
			this.rdoAllDivisions.TabIndex = 1;
			this.rdoAllDivisions.Text = "&All Divisions";
			this.rdoAllDivisions.Click += new System.EventHandler(this.rdoAllDivisions_Click);
			this.rdoAllDivisions.CheckedChanged += new System.EventHandler(this.rdoAllDivisions_CheckedChanged);
			// 
			// grpReportCompilation
			// 
			this.grpReportCompilation.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReportCompilation.Controls.Add(this.rdoScheduleJob);
			this.grpReportCompilation.Controls.Add(this.rdoCreateNow);
			this.grpReportCompilation.Controls.Add(this.grpScheduleJob);
			this.grpReportCompilation.Location = new System.Drawing.Point(60, 148);
			this.grpReportCompilation.Name = "grpReportCompilation";
			this.grpReportCompilation.Size = new System.Drawing.Size(328, 120);
			this.grpReportCompilation.TabIndex = 2;
			this.grpReportCompilation.TabStop = false;
			this.grpReportCompilation.Text = "Report Compilation*";
			// 
			// rdoScheduleJob
			// 
			this.rdoScheduleJob.Location = new System.Drawing.Point(16, 40);
			this.rdoScheduleJob.Name = "rdoScheduleJob";
			this.rdoScheduleJob.Size = new System.Drawing.Size(120, 16);
			this.rdoScheduleJob.TabIndex = 1;
			this.rdoScheduleJob.Text = "&Schedule Print Job";
			this.rdoScheduleJob.CheckedChanged += new System.EventHandler(this.rdoScheduleJob_CheckedChanged);
			// 
			// rdoCreateNow
			// 
			this.rdoCreateNow.Checked = true;
			this.rdoCreateNow.Location = new System.Drawing.Point(16, 20);
			this.rdoCreateNow.Name = "rdoCreateNow";
			this.rdoCreateNow.Size = new System.Drawing.Size(124, 16);
			this.rdoCreateNow.TabIndex = 0;
			this.rdoCreateNow.TabStop = true;
			this.rdoCreateNow.Text = "Create Report &Now";
			// 
			// grpScheduleJob
			// 
			this.grpScheduleJob.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpScheduleJob.Controls.Add(this.cmbPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrintDate);
			this.grpScheduleJob.Controls.Add(this.dtpPrintDate);
			this.grpScheduleJob.Enabled = false;
			this.grpScheduleJob.Location = new System.Drawing.Point(8, 40);
			this.grpScheduleJob.Name = "grpScheduleJob";
			this.grpScheduleJob.Size = new System.Drawing.Size(312, 72);
			this.grpScheduleJob.TabIndex = 2;
			this.grpScheduleJob.TabStop = false;
			// 
			// cmbPrinterName
			// 
			this.cmbPrinterName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbPrinterName.Interval = 500;
			this.cmbPrinterName.Location = new System.Drawing.Point(96, 44);
			this.cmbPrinterName.Name = "cmbPrinterName";
			this.cmbPrinterName.Size = new System.Drawing.Size(208, 22);
			this.cmbPrinterName.TabIndex = 3;
			this.cmbPrinterName.SelectedIndexChanged += new System.EventHandler(this.cmbPrinterName_SelectedIndexChanged);
			// 
			// lblPrinterName
			// 
			this.lblPrinterName.Location = new System.Drawing.Point(24, 44);
			this.lblPrinterName.Name = "lblPrinterName";
			this.lblPrinterName.Size = new System.Drawing.Size(76, 20);
			this.lblPrinterName.TabIndex = 2;
			this.lblPrinterName.Text = "Printer Name*";
			this.lblPrinterName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblPrintDate
			// 
			this.lblPrintDate.Location = new System.Drawing.Point(24, 20);
			this.lblPrintDate.Name = "lblPrintDate";
			this.lblPrintDate.Size = new System.Drawing.Size(72, 20);
			this.lblPrintDate.TabIndex = 0;
			this.lblPrintDate.Text = "Print Date*";
			this.lblPrintDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpPrintDate
			// 
			this.dtpPrintDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpPrintDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpPrintDate.CustomFormat = "MM/dd/yyyy hh:mm";
			this.dtpPrintDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpPrintDate.Location = new System.Drawing.Point(96, 20);
			this.dtpPrintDate.Name = "dtpPrintDate";
			this.dtpPrintDate.Size = new System.Drawing.Size(208, 20);
			this.dtpPrintDate.TabIndex = 1;
			this.dtpPrintDate.Value = new System.DateTime(2003, 6, 20, 15, 24, 4, 467);
			this.dtpPrintDate.ValueChanged += new System.EventHandler(this.dtpPrintDate_ValueChanged);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(232, 272);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 3;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			this.btnOK.MouseHover += new System.EventHandler(this.HoverOK);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnCancel.Location = new System.Drawing.Point(312, 272);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 4;
			this.btnCancel.Text = "&Cancel";
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.picImage);
			this.grpImage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 236);
			this.grpImage.TabIndex = 6;
			this.grpImage.TabStop = false;
			// 
			// picImage
			// 
			this.picImage.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
			this.picImage.Location = new System.Drawing.Point(4, 12);
			this.picImage.Name = "picImage";
			this.picImage.Size = new System.Drawing.Size(45, 45);
			this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picImage.TabIndex = 0;
			this.picImage.TabStop = false;
			// 
			// grpDateRange
			// 
			this.grpDateRange.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDateRange.Controls.Add(this.dtpEndDate);
			this.grpDateRange.Controls.Add(this.lblEndDate);
			this.grpDateRange.Controls.Add(this.lblStartDate);
			this.grpDateRange.Controls.Add(this.dtpStartDate);
			this.grpDateRange.Location = new System.Drawing.Point(60, 32);
			this.grpDateRange.Name = "grpDateRange";
			this.grpDateRange.Size = new System.Drawing.Size(328, 52);
			this.grpDateRange.TabIndex = 0;
			this.grpDateRange.TabStop = false;
			this.grpDateRange.Text = "Report Date Range";
			// 
			// dtpEndDate
			// 
			this.dtpEndDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpEndDate.CustomFormat = "MM/dd/yyyy";
			this.dtpEndDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpEndDate.Location = new System.Drawing.Point(224, 20);
			this.dtpEndDate.Name = "dtpEndDate";
			this.dtpEndDate.Size = new System.Drawing.Size(88, 20);
			this.dtpEndDate.TabIndex = 3;
			this.dtpEndDate.Value = new System.DateTime(2100, 1, 1, 23, 59, 0, 0);
			this.dtpEndDate.ValueChanged += new System.EventHandler(this.dtpEndDate_ValueChanged);
			// 
			// lblEndDate
			// 
			this.lblEndDate.Location = new System.Drawing.Point(172, 20);
			this.lblEndDate.Name = "lblEndDate";
			this.lblEndDate.Size = new System.Drawing.Size(56, 20);
			this.lblEndDate.TabIndex = 2;
			this.lblEndDate.Text = "End Date*";
			this.lblEndDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblStartDate
			// 
			this.lblStartDate.Location = new System.Drawing.Point(8, 20);
			this.lblStartDate.Name = "lblStartDate";
			this.lblStartDate.Size = new System.Drawing.Size(60, 20);
			this.lblStartDate.TabIndex = 0;
			this.lblStartDate.Text = "Start Date*";
			this.lblStartDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpStartDate
			// 
			this.dtpStartDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpStartDate.CustomFormat = "MM/dd/yyyy";
			this.dtpStartDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpStartDate.Location = new System.Drawing.Point(68, 20);
			this.dtpStartDate.Name = "dtpStartDate";
			this.dtpStartDate.Size = new System.Drawing.Size(88, 20);
			this.dtpStartDate.TabIndex = 1;
			this.dtpStartDate.Value = new System.DateTime(1900, 1, 1, 0, 0, 0, 0);
			this.dtpStartDate.ValueChanged += new System.EventHandler(this.dtpStartDate_ValueChanged);
			// 
			// DlgDivisionWorkloadReportCriteria
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(392, 305);
			this.Controls.Add(this.grpDivision);
			this.Controls.Add(this.grpReportCompilation);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.grpDateRange);
			this.hlphelpChm.SetHelpKeyword(this, "Division_Workload_Report.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(400, 332);
			this.Name = "DlgDivisionWorkloadReportCriteria";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Division Workload Report";
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpDateRange, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.grpReportCompilation, 0);
			this.Controls.SetChildIndex(this.grpDivision, 0);
			this.grpDivision.ResumeLayout(false);
			this.grpReportCompilation.ResumeLayout(false);
			this.grpScheduleJob.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.grpDateRange.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Get/Set StartDate
		/// </summary>
		public DateTime StartDate
		{
			get
			{
				DateTime startDate = new DateTime(this.dtpStartDate.Value.Year,
					this.dtpStartDate.Value.Month,
					this.dtpStartDate.Value.Day,
					0,
					0,
					0);
				return startDate;
			}
			set
			{
				this.dtpStartDate.Value = value;
			}
		}

		/// <summary>
		/// Get/Set EndDate
		/// </summary>
		public DateTime EndDate
		{
			get
			{
				DateTime endDate = new DateTime(this.dtpEndDate.Value.Year,
					this.dtpEndDate.Value.Month,
					this.dtpEndDate.Value.Day,
					23,
					59,
					59);
				return endDate;
			}
			set
			{
				this.dtpEndDate.Value = value;
			}
		}

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC079.DlgDivisionWorkloadReportCriteria());
			//
			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = true;
			//
			this.SetThisToolTip(btnCancel,Common.StrRes.Tooltips.Common.Cancel());
			//
			this.dtpStartDate.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpEndDate.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpPrintDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;

			this.dtpEndDate.Value = this.workloadReport.EndDate;
			this.dtpStartDate.Value = this.workloadReport.StartDate;
			System.DateTime _currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpPrintDate.Value = _currentDate;

			// Added 1/6/05 RDH 
			// Following should cause the ok button to activate/de-activate
			// according to the state of the report object.
			this.workloadReport.Valid += new System.EventHandler(this.CheckValid);
			this.workloadReport.Invalid += new System.EventHandler(this.CheckValid);
			this.workloadReport.IsDirtyChanged += new System.EventHandler(this.CheckValid);
			this.workloadReport.DivisionCode=Common.LogonUser.LogonUserDivisionCode;
			if (ThisUser.DivisionsAndRoles.EffectiveDivisions.Count == 1)
			{
				this.rdoAllDivisions.Enabled = false;
			}
		}

		/// <summary>
		/// Added 1/6/04 RDH
		/// Added method to populate the Printers drop down
		/// list for scheduling.
		/// </summary>
		public void LoadPrinters()
		{
			this.cmbPrinterName.Items.Clear();
			//
			foreach (string printerName in BOL.VbecsReport.GetPrinters())
			{
				cmbPrinterName.Items.Add(printerName);
			}
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{			
			using( WaitCursor _cursor = new WaitCursor() )
			{
				workloadReport.IsMultiDivisional=this.rdoAllDivisions.Checked;
				workloadReport.StartDate=this.StartDate;
				workloadReport.EndDate=this.EndDate;

				if(workloadReport.IsScheduled)
				{
					this.workloadReport.PrintDate=this.dtpPrintDate.Value; 
					this.workloadReport.PrinterName=this.cmbPrinterName.Text;
					this.workloadReport.Schedule();
					this.DialogResult=DialogResult.Cancel;
				}
				else
				{
					DataTable dtWorkloadReport = workloadReport.GetDivisionWorkloadReport(this._singleDivision);
#if DEBUG
					//dtWorkloadReport.DataSet.WriteXml("d:\\temp\\WorkloadReport.xml", XmlWriteMode.WriteSchema);
#endif
					if (dtWorkloadReport.Rows.Count == 0)
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC077.NoRecordsFound());
						this.Close();
						return;
					}
					else if(dtWorkloadReport.Rows.Count/20 > 50)
					{
						DialogResult _result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC049.PageCountAlert());
						if( _result != DialogResult.Yes )
						{
							return;
						}
						else
						{
							//Alert user that building report may take a few minutes
							GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC049.Warning());
						}
					}

					FrmDivisionWorkloadReport frm = new FrmDivisionWorkloadReport(dtWorkloadReport, this.StartDate, this.EndDate);
					frm.MdiParent = this._mdiParent;
					frm.Show();
				}
				
				this.Close();
			}
		}

		private void dtpStartDate_ValueChanged(object sender, System.EventArgs e)
		{
			this.workloadReport.StartDate = this.dtpStartDate.Value;
			//
			CheckDates();
		}

		private void dtpEndDate_ValueChanged(object sender, System.EventArgs e)
		{
			this.workloadReport.EndDate = this.dtpEndDate.Value;
			//
			CheckDates();
		}

		private void CheckDates()
		{
			if (this.workloadReport.StartDate > this.workloadReport.EndDate)
			{
				this.errError.SetVbecsError(this.dtpEndDate,Common.StrRes.SysErrMsg.Common.CannotbeGreaterError("Start date", "End date").ResString); // **** 508 Compliance ***
			}
			else
			{
				this.errError.SetVbecsError(this.dtpEndDate, ""); // **** 508 Compliance ***
			}
			//
			if (this.workloadReport.IsScheduled)
			{
				if (this.workloadReport.EndDate > this.workloadReport.PrintDate)
				{
					this.errError.SetVbecsError(this.dtpPrintDate, Common.StrRes.SysErrMsg.Common.CannotbeLessError("Print date", "End date").ResString); // **** 508 Compliance ***
				}
				else
				{
					this.errError.SetVbecsError(this.dtpPrintDate, ""); // **** 508 Compliance ***
				}
			}
			else
			{
				this.errError.SetVbecsError(this.dtpPrintDate, ""); // **** 508 Compliance ***
			}
		}

		private void rdoCurrentDivision_Click(object sender, System.EventArgs e)
		{
			this._singleDivision = true;
		}

		private void rdoAllDivisions_Click(object sender, System.EventArgs e)
		{
			this._singleDivision = false;
		}

		private void rdoScheduleJob_CheckedChanged(object sender, System.EventArgs e)
		{
			this.grpScheduleJob.Enabled=this.rdoScheduleJob.Checked;
			this.workloadReport.IsScheduled=this.rdoScheduleJob.Checked;
			if ((this.workloadReport.IsScheduled) && (this.workloadReport.PrintDate == DateTime.MinValue))
			{
				this.dtpPrintDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			}

		}

		private void dtpPrintDate_ValueChanged(object sender, System.EventArgs e)
		{
			if (this.workloadReport.IsScheduled)
			{
				this.workloadReport.PrintDate = this.dtpPrintDate.Value;
			}
			//
			CheckDates();
		}

		private void cmbPrinterName_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(cmbPrinterName.SelectedItem!=null)
			{
				string printer=this.cmbPrinterName.Text;
				for(int i=0; i<this.cmbPrinterName.Items.Count; i++)
				{
					if(printer==this.cmbPrinterName.Items[i].ToString())
					{
						this.workloadReport.PrinterName = cmbPrinterName.SelectedItem.ToString();
					}
				}
			}		
			else
			{
				this.workloadReport.PrinterName=String.Empty;
			}
		}

		private void rdoAllDivisions_CheckedChanged(object sender, System.EventArgs e)
		{
			this.workloadReport.IsMultiDivisional=this.rdoAllDivisions.Checked; 
		}

		// Added 1/6/04 RDH Copied from UC 48. Used to handle
		// the enabling of the ok button.
		// TO-DO: Add the broken rules for this form.
		private void CheckValid(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = (this.workloadReport.IsValid);
		}

		private void HoverOK(object sender, System.EventArgs e)
		{
			if (this.workloadReport.IsValid)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
			}
			else
			{
				this.btnOK.SetToolTip(this.workloadReport.GetBrokenRulesMessage(gov.va.med.vbecs.Common.VbecsBrokenRules.ProlongedTransfusionReport.FormClassName));
			}
		}
	}
}

